import 'package:flutter/material.dart';
import 'package:flutter_riverpod/legacy.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:wordpress_app/utils/toast.dart';

class CommentsBloc extends ChangeNotifier{


  List<String> _flagList = [];
  List<String> get flagList => _flagList;



  Future getFlagList () async {
    final SharedPreferences sp = await SharedPreferences.getInstance();
    _flagList = sp.getStringList('flag_list') ?? [];
    notifyListeners();
  }


  Future<void> addToFlagList (BuildContext context, int categoryId, int postId, int commentId)async{
    final SharedPreferences sp = await SharedPreferences.getInstance();
    String flagId = "$categoryId-$postId-$commentId";
    await getFlagList().then((value)async{
      List<String> a = _flagList;
      if(a.contains(flagId)){
        openToast1('You have flagged this comment already');
      }else{
        a.add(flagId);
        await sp.setStringList('flag_list', a);
      }
      
    });
  }


  Future<void> removeFromFlagList (BuildContext context, int categoryId, int postId, int commentId)async{
    final SharedPreferences sp = await SharedPreferences.getInstance();
    String flagId = "$categoryId-$postId-$commentId";
    await getFlagList().then((value)async{
      List<String> a = _flagList;
      if(a.contains(flagId)){
        a.remove(flagId);
        await sp.setStringList('flag_list', a);
      }else{
        debugPrint('not possible');
      }
      
    });
  }


}

final commentsBlocProvider = ChangeNotifierProvider<CommentsBloc>((ref) {
  return CommentsBloc();
});
